# E14 — Shapiro-like Delay (v2)

This repository contains a single-file present-act engine and a minimal manifest to reproduce the **E14 (v2)** run.

## What this sim checks
- Integer-only **gate**: advance one cell when `(t % P(r) == 0)` with `P(r) = 1 + floor(kappa/r)`.
- Straight eastbound rays at fixed `y` with impact parameter `b`, delays defined as `Δt = t_ON - t_OFF`.
- Fit `Δt(b)` to `log(L/b)` and check: **R²**, **amplitude band**, **monotonicity**, and **mesh consistency** (N=256 vs N=192).

## How to run
```bash
python3 engine_e14_shapiro_delay.py \
  --manifest E14_shapiro_like_delay_v2/2025-11-05T21-32-43Z/config/manifest_e14_template.json \
  --outdir   E14_shapiro_like_delay_v2/2025-11-05T21-32-43Z/
```
> Tip: You can copy the `2025-11-05T21-32-43Z` folder and re-run with a fresh UTC timestamp if you like.

## Result from the included run
```
E14_v2 PASS=True A_hat_coarse=51.869577 R2_c=0.9697 A_hat_fine=51.869577 R2_f=0.9697 ΔA=0.000000 relΔ=0.000
```
See `outputs/audits/e14_audit.json` for details.
